(() => {
  const authToken = "Bearer AAAAAAAAAAAAAAAAAAAAANRILgAAAAAAnNwIzUejRCOuH5E6I8xnZz4puTs%3D1Zv7ttfk8LF81IUq16cHjhLTvJu4FA33AGWWjCpTnA";
  const queryUrl = "https://x.com/i/api/graphql/XRqGa7EeokUU5kppkh13EA/AboutAccountQuery";
  const csrf = decodeURIComponent(document.cookie.match(/(?:^|; )ct0=([^;]+)/)?.[1] || "");

  const cache = new Map();

  // Simple IndexedDB cache (works reliably)
  const db = indexedDB.open("xFlagCache", 1);
  db.onupgradeneeded = () => db.result.createObjectStore("data");
  db.onsuccess = () => {
    const store = db.result.transaction("data").objectStore("data");
    store.openCursor().onsuccess = e => {
      const cursor = e.target.result;
      if (cursor) { cache.set(cursor.key, cursor.value); cursor.continue(); }
    };
  };

  const countryFlags = {
    "Afghanistan":"🇦🇫","Albania":"🇦🇱","Algeria":"🇩🇿","Andorra":"🇦🇩","Angola":"🇦🇴","Argentina":"🇦🇷","Armenia":"🇦🇲","Australia":"🇦🇺","Austria":"🇦🇹",
    "Azerbaijan":"🇦🇿","Bahamas":"🇧🇸","Bahrain":"🇧🇭","Bangladesh":"🇧🇩","Barbados":"🇧🇧","Belarus":"🇧🇾","Belgium":"🇧🇪","Belize":"🇧🇿","Benin":"🇧🇯",
    "Bolivia, Plurinational State of":"🇧🇴","Bosnia and Herzegovina":"🇧🇦","Brazil":"🇧🇷","Bulgaria":"🇧🇬","Cambodia":"🇰🇭","Cameroon":"🇨🇲","Canada":"🇨🇦",
    "Chile":"🇨🇱","China":"🇨🇳","Colombia":"🇨🇴","Costa Rica":"🇨🇷","Croatia":"🇭🇷","Cuba":"🇨🇺","Cyprus":"🇨🇾","Czech Republic":"🇨🇿","Denmark":"🇩🇰",
    "Dominican Republic":"🇩🇴","Ecuador":"🇪🇨","Egypt":"🇪🇬","Estonia":"🇪🇪","Ethiopia":"🇪🇹","Finland":"🇫🇮","France":"🇫🇷","Georgia":"🇬🇪","Germany":"🇩🇪",
    "Ghana":"🇬🇭","Greece":"🇬🇷","Guatemala":"🇬🇹","Honduras":"🇭🇳","Hong Kong":"🇭🇰","Hungary":"🇭🇺","Iceland":"🇮🇸","India":"🇮🇳","Indonesia":"🇮🇩",
    "Iran, Islamic Republic of":"🇮🇷","Iraq":"🇮🇶","Ireland":"🇮🇪","Israel":"🇮🇱","Italy":"🇮🇹","Jamaica":"🇯🇲","Japan":"🇯🇵","Kazakhstan":"🇰🇿","Kenya":"🇰🇪",
    "Korea, Republic of":"🇰🇷","Kuwait":"🇰🇼","Latvia":"🇱🇻","Lebanon":"🇱🇧","Libya":"🇱🇾","Lithuania":"🇱🇹","Luxembourg":"🇱🇺","Malaysia":"🇲🇾",
    "Mexico":"🇲🇽","Morocco":"🇲🇦","Netherlands":"🇳🇱","New Zealand":"🇳🇿","Nigeria":"🇳🇬","Norway":"🇳🇴","Pakistan":"🇵🇰","Panama":"🇵🇦","Peru":"🇵🇪",
    "Philippines":"🇵🇭","Poland":"🇵🇱","Portugal":"🇵🇹","Qatar":"🇶🇦","Romania":"🇷🇴","Russian Federation":"🇷🇺","Saudi Arabia":"🇸🇦","Senegal":"🇸🇳",
    "Serbia":"🇷🇸","Singapore":"🇸🇬","Slovakia":"🇸🇰","Slovenia":"🇸🇮","South Africa":"🇿🇦","Spain":"🇪🇸","Sweden":"🇸🇪","Switzerland":"🇨🇭","Taiwan":"🇹🇼",
    "Thailand":"🇹🇭","Trinidad and Tobago":"🇹🇹","Tunisia":"🇹🇳","Turkey":"🇹🇷","Ukraine":"🇺🇦","United Arab Emirates":"🇦🇪","United Kingdom":"🇬🇧",
    "United States":"🇺🇸","Uruguay":"🇺🇾","Venezuela, Bolivarian Republic of":"🇻🇪","Viet Nam":"🇻🇳","Zimbabwe":"🇿🇼",
    "Europe":"🇪🇺","European Union":"🇪🇺","European Economic Area":"🇪🇺","Schengen Area":"🇪🇺",
    "Africa":"🌍","Sub-Saharan Africa":"🇿🇦","Middle East & North Africa":"🇦🇪",
    "East Asia & Pacific":"🌏","South Asia":"🍛","West Asia":"🕋","Central Asia":"🕌",
    "North America":"🦅","Latin America & Caribbean":"🦜","South America":"🌎", "Eastern Europe":"🏰",
    "Australasia":"🇦🇺","Oceania":"🇵🇬"
  };

  const fetchInfo = async username => {
    const url = `${queryUrl}?variables=${encodeURIComponent(JSON.stringify({screenName:username}))}`;
    const res = await fetch(url, {
      headers: { authorization: authToken, "x-csrf-token": csrf },
      credentials: "include"
    });
    if (!res.ok) return null;
    const json = await res.json();
    const about = json?.data?.user_result_by_screen_name?.result?.about_profile || {};
    const country = about.account_based_in || null;
    const govId = !!about.gov_id_verification_badge?.is_verified;
    return { country, govId };
  };

  const addBadges = async el => {
    if (el.dataset.done) return;
    el.dataset.done = "1";

    const link = el.querySelector('a[href^="/"]');
    if (!link) return;
    const username = link.getAttribute("href").slice(1).split("/")[0];

    let info = cache.get(username);
    if (!info) {
      info = await fetchInfo(username);
      if (info) {
        cache.set(username, info);
        // Save to IndexedDB
        try {
          const dbSave = indexedDB.open("xFlagCache", 1);
          dbSave.onsuccess = () => dbSave.result.transaction("data", "readwrite").objectStore("data").put(info, username);
        } catch(e) {}
      }
    }
    if (!info || (!info.country && !info.govId)) return;

   
    const line = el.querySelector('div[dir="ltr"], div[dir="auto"]');
    if (!line) return;


    line.querySelectorAll('.x-before-flag').forEach(e => e.remove());
    
    // Optional: prevent double flags if user already has one in their name
    // if (line.textContent.includes('') || line.textContent.includes('')) return;

    const wrapper = document.createElement("span");
    wrapper.className = "x-before-flag";
    wrapper.style.cssText = "display:inline-flex;gap:5px;align-items:center;margin-right:6px;font-size:1.1em;";

    if (info.country && countryFlags[info.country]) {
      const flag = document.createElement("span");
      flag.textContent = countryFlags[info.country];
      flag.title = info.country;
      wrapper.appendChild(flag);
    }
    if (info.govId) {
      const id = document.createElement("span");
      id.textContent = "ID";
      id.style.cssText = "background:#1d9bf0;color:white;padding:1px 6px;border-radius:4px;font-size:0.75em;font-weight:bold;";
      id.title = "Government ID verified";
      wrapper.appendChild(id);
    }

    if (wrapper.children.length) {
      line.insertBefore(wrapper, line.lastElementChild);
    }
  };

  // Dabitch says observe everything
  new MutationObserver(muts => {
    for (const m of muts)
      for (const n of m.addedNodes)
        if (n.nodeType === 1) {
          if (n.matches('[data-testid="User-Name"]')) addBadges(n);
          n.querySelectorAll?.('[data-testid="User-Name"]').forEach(addBadges);
        }
  }).observe(document.body, { childList: true, subtree: true });

  // Initial load
  document.querySelectorAll('[data-testid="User-Name"]').forEach(addBadges);
})();